#ifndef _Command_CPP
#define _Command_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SqlExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedSource/LZARICode.H"

#include "../../SharedClasses/CRC32/CRC.H"

#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "Command.H"
#include "SQLImport.H"
#include "Console.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int SendNextStatement(CSockSrvr *pSockSrvr, int iClient);
bool ReceiveFileData(CSockSrvr *pSockSrvr, int iClient, char *sFileName);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	int ProcessCommand(CSockSrvr *pSockSrvr, int iClient, char *sRecvBuf, int iRecvBufSz);

	Processes a command from the peer.

	Possible return Values:
		CMD_OK    The command was a success, all is well.
		CMD_DONE  The command was a success, close the connection.
		CMD_ERROR The command failed due to an error.
*/
int ProcessCommand(CSockSrvr *pSockSrvr, int iClient, char *sCmdBuf, int iCmdBufSz)
{
    char sCmdData[IDEAL_RECV_SIZE + 1];

	int iSendBufSz = 0;
	int iCmdDataSz = 0;
	int iCmdFlagLength = 0;

	//pSockSrvr->SetNextSendData(iClient, "::Ping");

	if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Ping")))
    {
		pSockSrvr->SetNextSendData(iClient, "::Pong");
		return CMD_OK;
	}
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Pong")))
    {
		//WriteLog(pSockSrvr->icClientID[iClient], "Received ping reply.");
		pSockSrvr->SetNextSendData(iClient, "::Ping");
		return CMD_OK;
	}
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Msg->")))
    {
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		WriteLog(pSockSrvr->icClientID[iClient], sCmdData);
		return CMD_OK;
	}
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::SendFirstSQL")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Client is requesting first SQL string.");

        char sSQL[255];

		if(gbUseCompression)
			strcpy(sCmdData, "::Compression->On");
		else strcpy(sCmdData, "::Compression->Off");

		pSockSrvr->SetNextSendData(iClient, sCmdData);

		//Select statement to get all of the Dymanic and Core statements that need to be executed.
		strcpy(sSQL, "SELECT Statement, OnSuccess, OnFailure, ImportTable, [Sequence]"
			" FROM SQLExch_Statements WHERE Active = 1");

        if(!CCI[iClient].cCustSQL.Execute(sSQL, &CCI[iClient].rsData))
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Failed to executed FirstSQL statement.");
			return CMD_ERROR;
		}

		/*
		//Select statement to get all of the Dymanic and Core statements that need to be executed.
		strcpy(sSQL, "(SELECT Statement, OnSuccess, OnFailure, ImportTable, [Sequence]"
			" FROM SQLExch_Statements WHERE Active = 1"
			" )UNION("
			" SELECT Statement, OnSuccess, OnFailure, ImportTable, [Sequence]"
			" FROM SQLExch_Statements_Core WHERE Active = 1"
			" )"
			" ORDER BY [Sequence]");

        if(!CCI[iClient].cCustSQL.Execute(sSQL, &CCI[iClient].rsData))
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Failed to executed FirstSQL statement.");
			return CMD_ERROR;
		}
		int iSendResult = SendNextStatement(pSockSrvr, iClient);
		*/

		strcpy(sSQL, "SELECT Statement, OnSuccess, OnFailure, ImportTable, Identifier, Sequence, Active, Comments"
			" FROM SQLExch_Statements WHERE Dirty = 1");

		int iSendResult = SendStatement(pSockSrvr, iClient, sSQL, "SQLExch_Statements");
		if(iSendResult != SENDNEXTSTATEMENT_SUCCESS)
		{
	        CCI[iClient].rsData.Close();
		}
        if(iSendResult == SENDNEXTSTATEMENT_FAILURE){
            WriteLog(pSockSrvr->icClientID[iClient], "Failed to send first statement.");
            return CMD_ERROR;
        }
        else if(iSendResult == SENDNEXTSTATEMENT_DONE){
            WriteLog(pSockSrvr->icClientID[iClient], "End of statements.");
            pSockSrvr->SetNextSendData(iClient, "::EndOfStatements");
            return CMD_OK;
        }

		//WriteLog(pSockSrvr->icClientID[iClient], "Successfully sent first SQL statement.");

		return CMD_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::SendNextSQL")))
    {
		//WriteLog(pSockSrvr->icClientID[iClient], "Client is requesting next SQL string.");

        int iSendResult = SendNextStatement(pSockSrvr, iClient);
        if(iSendResult == SENDNEXTSTATEMENT_FAILURE){
            WriteLog(pSockSrvr->icClientID[iClient], "Failed to send next statement.");
            return CMD_ERROR;
        }
        else if(iSendResult == SENDNEXTSTATEMENT_DONE){
            WriteLog(pSockSrvr->icClientID[iClient], "End of statements.");
            pSockSrvr->SetNextSendData(iClient, "::EndOfStatements");
            return CMD_OK;
        }

		//WriteLog(pSockSrvr->icClientID[iClient], "Successfully sent next SQL statement.");

		return CMD_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::SendingFileData->")))
    {
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		WriteLog(pSockSrvr->icClientID[iClient], "Client sending file data.");

        sprintf(CCI[iClient].sFileName, "%s\\%s\\%s.wpd", gsImportTempDir, CCI[iClient].sCompanyName, sCmdData);
        CreateFolderStructure(CCI[iClient].sFileName);

		ReceiveFileData(pSockSrvr, iClient, CCI[iClient].sFileName);

		if(ImportSQLResults(pSockSrvr, iClient, CCI[iClient].sFileName))
        {
			//pSockSrvr->SetNextSendData(iClient, "::LastImportSuccess");
			pSockSrvr->SetNextSendData(iClient, "::Msg->The last import succeeded.");

			int iSendResult = SendResponseStatement(pSockSrvr, iClient, true);
			if(iSendResult == SENDNEXTSTATEMENT_FAILURE){
				WriteLog(pSockSrvr->icClientID[iClient], "Failed to send next statement.");
				return CMD_ERROR;
			}
			else if(iSendResult == SENDNEXTSTATEMENT_DONE){
				WriteLog(pSockSrvr->icClientID[iClient], "End of statements.");
				pSockSrvr->SetNextSendData(iClient, "::EndOfStatements");
				return CMD_OK;
			}

			return CMD_OK;
        }
        else{
            // FIXME: Should we return CMD_OK or CMD_ERROR?
			//pSockSrvr->SetNextSendData(iClient, "::LastImportFailed");
			pSockSrvr->SetNextSendData(iClient, "::Msg->The last import failed.");

			int iSendResult = SendResponseStatement(pSockSrvr, iClient, false);
			if(iSendResult == SENDNEXTSTATEMENT_FAILURE){
				WriteLog(pSockSrvr->icClientID[iClient], "Failed to send next statement.");
				return CMD_ERROR;
			}
			else if(iSendResult == SENDNEXTSTATEMENT_DONE){
				WriteLog(pSockSrvr->icClientID[iClient], "End of statements.");
				pSockSrvr->SetNextSendData(iClient, "::EndOfStatements");
				return CMD_OK;
			}

			//WriteLog(pSockSrvr->icClientID[iClient], "Successfully sent next SQL statement.");
			
			return CMD_OK;
        }

		return CMD_OK;
	}

	WriteLog(pSockSrvr->icClientID[iClient], "Received unknown command.");
	return CMD_ERROR;	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ReceiveFileData(CSockSrvr *pSockSrvr, int iClient, char *sFileName)
{
    FILE *hTargetHandle = NULL;

    char sFullFile[MAX_PATH];
	char sRecvBuf[IDEAL_RECV_SIZE + 1];
    int iRecvBufSz = 0;

	DWORD dwDataCRC = 0xffffffff;

	WriteLog(pSockSrvr->icClientID[iClient], "Begining file transfer.");

	if(gbUseCompression)
	{
		sprintf(sFullFile, "%s.lza", sFileName);
	}
	else{
		strcpy(sFullFile, sFileName);
	}

	if( (hTargetHandle = fopen(sFullFile, "wb")) == NULL)
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Failed to open export file for binary write.");
        return false;
    }

    while(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
    {
        if(pSockSrvr->GetClientData(iClient, sRecvBuf, &iRecvBufSz))
        {
			if(iRecvBufSz == 5)
			{
				sRecvBuf[iRecvBufSz] = '\0';
				if(strcmp(sRecvBuf, "::EOF") == 0)
				{
					break;
				}
			}

			fwrite(sRecvBuf, sizeof(char), iRecvBufSz, hTargetHandle);
		}
		else Sleep(1);
	}

	fclose(hTargetHandle);

	if(gbUseCompression)
	{
		float dwBeforeSz = 0;
		float dwAfterSz = 0;

		sprintf(sFullFile, "%s.lza", sFileName);

		dwBeforeSz = (float) Get_FileSize(sFullFile);

		sprintf(sRecvBuf, "Decompressing file. (%.2f KB)", dwBeforeSz / 1024);
		WriteLog(pSockSrvr->icClientID[iClient], sRecvBuf);
		DecompressFile(sFullFile, sFileName);

		dwAfterSz = (float) Get_FileSize(sFileName);

		sprintf(sRecvBuf, "File size increased from %.2f KB to %.2f KB. (%.2f %% Decompression).",
			dwBeforeSz / 1024, dwAfterSz / 1024, (dwBeforeSz / dwAfterSz) * 100);
		WriteLog(pSockSrvr->icClientID[iClient], sRecvBuf);
	}

	if(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
	{
		return true;
	}
	else return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int SendStatement(CSockSrvr *pSockSrvr, int iClient, char *sSQL, char *sImportTable)
{
    char SendData[IDEAL_SEND_SIZE + 1];

	int iImportTableSz = 0;

	//If the ImportTable is not NULL send it over to the client.
	if(sImportTable != NULL)
	{
		sprintf(SendData, "::ImportTable->%s", sImportTable);
		if(!pSockSrvr->SetNextSendData(iClient, SendData))
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Failed to send ImportTable.");
			return SENDNEXTSTATEMENT_FAILURE;
		}
	}

    sprintf(SendData, "::SQL->%s", sSQL);
    if(!pSockSrvr->SetNextSendData(iClient, SendData))
	{
		WriteLog(pSockSrvr->icClientID[iClient], "Failed to send SQL string.");
		return SENDNEXTSTATEMENT_FAILURE;
	}

	return SENDNEXTSTATEMENT_SUCCESS;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int SendNextStatement(CSockSrvr *pSockSrvr, int iClient)
{
	int iStatementLen = 0;
    char sStatement[IDEAL_SEND_SIZE];
    int iImportTableLen = 0;
    char sImportTable[255 + 1];

    if(!CCI[iClient].rsData.Fetch())
    {
        // This is not an error. It means there are no more rows.
        return SENDNEXTSTATEMENT_DONE;
    }

	if(!CCI[iClient].rsData.sColumnEx(1, sStatement, sizeof(sStatement), &iStatementLen))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "DBGetData Statement error.");
        return SENDNEXTSTATEMENT_FAILURE;
    }

	if(iStatementLen == -1)
	{
		return SENDNEXTSTATEMENT_FAILURE;
	}

	if(!CCI[iClient].rsData.sColumnEx(4, sImportTable, sizeof(sImportTable), &iImportTableLen))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "DBGetData ImportTable error.");
        return SENDNEXTSTATEMENT_FAILURE;
    }

	if(iImportTableLen > 0)
	{
		return SendStatement(pSockSrvr, iClient, sStatement, sImportTable);
	}
	else return SendStatement(pSockSrvr, iClient, sStatement, NULL);

	return SENDNEXTSTATEMENT_FAILURE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int SendResponseStatement(CSockSrvr *pSockSrvr, int iClient, bool bSuccess)
{
	int iStatementLen = 0;
	int iCol = 0;
    char sStatement[IDEAL_SEND_SIZE];

	strcpy(sStatement, "");

	if(bSuccess)
	{
		iCol = 2;
	}
	else{
		iCol = 3;
	}

	if(!CCI[iClient].rsData.sColumnEx(iCol, sStatement, sizeof(sStatement), &iStatementLen))
	{
		//This is not an error. This is MORE THAN LIKELY just caused by the fact that
		//	the cursor position has not been set by the calling of the first FETCH.
		
		return SendNextStatement(pSockSrvr, iClient);
	}

	if(iStatementLen == -1)
	{
		return SendNextStatement(pSockSrvr, iClient);
	}

	return SendStatement(pSockSrvr, iClient, sStatement, NULL);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
